using System;
using System.Collections.Generic;

class Program
{
    static void Main()
    {
        int n = int.Parse(Console.ReadLine());
        long[] x = new long[n];
        long[] y = new long[n];

        for (int i = 0; i < n; i++)
        {
            string[] s = Console.ReadLine().Split();
            x[i] = long.Parse(s[0]);
            y[i] = long.Parse(s[1]);
        }

        Dictionary<long, long> diag1 = new Dictionary<long, long>();
        Dictionary<long, long> diag2 = new Dictionary<long, long>();

        for (int i = 0; i < n; i++)
        {
            long k1 = x[i] + y[i];
            long k2 = x[i] - y[i];

            if (!diag1.ContainsKey(k1)) diag1[k1] = 0;
            diag1[k1]++;

            if (!diag2.ContainsKey(k2)) diag2[k2] = 0;
            diag2[k2]++;
        }

        long total = 0;

        foreach (var val in diag1.Values)
            total += val * (val - 1) / 2;

        foreach (var val in diag2.Values)
            total += val * (val - 1) / 2;

        Console.WriteLine(total);
    }
}